* Definicia indexovych mnozin
Sets i /GS,PR,PF,W,NT,E,G,HH,CAP,F/;

alias(j,i)

Parameters A0(i,j)
           B0(i,j) SAM Year '95,
           X0(j)   column & row sum '95
           A1(i,j)
           B1(i,j) SAM Year '96,
           X1(j)   column & row sum '96;

$libinclude xlimport B0 c:\MaxEnt\Data\SAM-95-96.xls data!b4:l14
$libinclude xlimport B1 c:\MaxEnt\Data\SAM-95-96.xls data!b24:l34
$libinclude xlimport X0 c:\MaxEnt\Data\SAM-95-96.xls data!c16:l17
$libinclude xlimport X1 c:\MaxEnt\Data\SAM-95-96.xls data!c36:l37

    B0(i,j)=B0(i,j)/1000;
    B1(i,j)=B1(i,j)/1000;
    x0(j)=x0(j)/1000;
    x1(j)=x1(j)/1000;

    A1(i,j)=B1(i,j)/X1(j);
    A0(i,j)=B0(i,j)/X0(j);

Scalar N1,epsilon;
    N1=sum((i,j), 1);
    epsilon=0.0001;

Parameters R(i),S(j),A1_HAT(i,j),B1_HAT(i,j);

A1_HAT(i,j)=A0(i,j);

While(
 smax(i, abs(X1(i)-sum(j, A1_HAT(i,j)*X1(j))))>epsilon
     or smax(j, abs(1-sum(i, A1_HAT(i,j))))>epsilon,
 if (smax(i, abs(X1(i)-sum(j, A1_HAT(i,j)*X1(j))))>epsilon,
       R(i) = X1(i)/sum(j, A1_HAT(i,j)*X1(j));
       loop(j, A1_HAT(i,j) = A1_HAT(i,j)*R(i));
     )
 if (smax(j, abs(1-sum(i, A1_HAT(i,j))))>epsilon,
       S(j) = 1/sum(i, A1_HAT(i,j));
       loop(i, A1_HAT(i,j) = A1_HAT(i,j)*S(j));
     )
 );

    B1_HAT(i,j) = A1_HAT(i,j)*X1(j);

   B1_HAT(i,j)=B1_HAT(i,j)*1000;
$libinclude xlexport B1_HAT c:\MaxEnt\Data\SAM-95-96.xls RAS!c4:m14
   B1_HAT(i,j)=B1_HAT(i,j)/1000;

option decimals = 5

Parameter  E_A(i,j),E_B(i,j),P_B(i,j);

       E_A(i,j) = A1_HAT(i,j)-A1(i,j);
       E_B(i,j) = B1_HAT(i,j)-B1(i,j);
       P_B(i,j)$B1(i,j) = abs(E_B(i,j))/B1(i,j);

Parameter MAD_A,SEM_A,
          MAD_B,SEM_B,
          MaxPE,MAPE,
          GOF_A,GOF_B,
          CORR_A,CORR_B,
          mean_A1_HAT,mean_A1,
          mean_B1_HAT,mean_B1,
          mean0,mean1,
          stddev0,stddev1;

       MAD_A = sum((i,j), abs(E_A(i,j)))/N1;
       SEM_A = sum((i,j), power(E_A(i,j),2))/N1;

       MAD_B = sum((i,j), abs(E_B(i,j)))/N1;
       SEM_B = sum((i,j), power(E_B(i,j),2))/N1;

       MaxPE = smax((i,j), P_B(i,j));
       MAPE = sum((i,j), P_B(i,j))/N1;

       GOF_A = sum((i,j)$A1_HAT(i,j), abs(power(E_A(i,j),2)/(N1*A1_HAT(i,j))));
       mean_A1_HAT=sum((i,j), A1_HAT(i,j))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A = (sum((i,j),(A1_HAT(i,j)-mean_A1_HAT)*(A1(i,j)-mean_A1))/N1)/
         (((sum((i,j),power(A1_HAT(i,j)-mean_A1_HAT,2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5);

       GOF_B = sum((i,j)$B1_HAT(i,j), abs(power(E_B(i,j),2)/(N1*B1_HAT(i,j))));
       mean_B1_HAT=sum((i,j), B1_HAT(i,j))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B = (sum((i,j),(B1_HAT(i,j)-mean_B1_HAT)*(B1(i,j)-mean_B1))/N1)/
         (((sum((i,j),power(B1_HAT(i,j)-mean_B1_HAT,2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5);

       mean0=sum((i,j), B0(i,j))/N1;
       mean1=sum((i,j), B1(i,j))/N1;
       stddev0=sum((i,j), power((B0(i,j)-mean0),2))/N1;
       stddev1=sum((i,j), power((B1(i,j)-mean1),2))/N1;

option decimals = 5

Display MAD_A,SEM_A,
        MAD_B,SEM_B,
        MaxPE,MAPE,
        GOF_A,GOF_B,
        CORR_A,CORR_B,
        stddev0,stddev1;